/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.blocks;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BonfireBlock
extends Block
implements SimpleWaterloggedBlock {
    private static final VoxelShape BONFIRE_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);

    public BonfireBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        return worldIn.m_8055_(blockpos).m_60783_((BlockGetter)worldIn, blockpos, Direction.UP);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return BONFIRE_SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (!entityIn.m_5825_() && entityIn instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)entityIn))) {
            entityIn.m_6469_(DamageSource.f_19305_, 1.0f);
            entityIn.m_20254_(3);
        }
        super.m_7892_(state, worldIn, pos, entityIn);
    }

    public void m_7100_(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(18) == 0) {
            worldIn.m_7785_((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), SoundEvents.f_11936_, SoundSource.BLOCKS, 1.5f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
        }
        if (rand.nextInt(10) == 0) {
            worldIn.m_7785_((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), SoundEvents.f_11784_, SoundSource.BLOCKS, (float)((double)0.6f + (double)rand.nextFloat() * 0.3), rand.nextFloat() * 0.6f + 0.5f, false);
        }
        for (int i = 0; i < 3; ++i) {
            double x = (double)pos.m_123341_() + rand.nextDouble();
            double y = (double)pos.m_123342_() + rand.nextDouble() * 0.5 + 1.5;
            double z = (double)pos.m_123343_() + rand.nextDouble();
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123755_, x, y, z, -0.03 + rand.nextDouble() * 0.06, rand.nextDouble() * 0.1, -0.03 + rand.nextDouble() * 0.06);
        }
    }

    public boolean m_6044_(BlockGetter worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return false;
    }

    public boolean m_7361_(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (fluidStateIn.m_76152_() == Fluids.f_76193_) {
            if (!worldIn.m_5776_()) {
                worldIn.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                worldIn.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.2f, 0.6f);
            } else {
                BonfireBlock.spawnExtinguishSmoke(worldIn, pos);
            }
            return true;
        }
        return false;
    }

    public static void spawnExtinguishSmoke(LevelAccessor world, BlockPos pos) {
        Random rand = world.m_5822_();
        for (int i = 0; i < 5; ++i) {
            double d0 = world.m_5822_().nextGaussian() * 0.02;
            double d1 = world.m_5822_().nextGaussian() * 0.02;
            double d2 = world.m_5822_().nextGaussian() * 0.02;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123796_, (double)pos.m_123341_() + (double)rand.nextFloat(), (double)pos.m_123342_() + 0.4 + (double)rand.nextFloat(), (double)pos.m_123343_() + (double)rand.nextFloat(), d0, d1, d2);
        }
        world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.25 + rand.nextDouble() / 2.0 * (double)(rand.nextBoolean() ? 1 : -1), (double)pos.m_123342_() + 0.4, (double)pos.m_123343_() + 0.25 + rand.nextDouble() / 2.0 * (double)(rand.nextBoolean() ? 1 : -1), 0.0, 0.005, 0.0);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return this.m_7898_(stateIn, (LevelReader)worldIn, currentPos) ? stateIn : Blocks.f_50016_.m_49966_();
    }
}

